#include <avr/io.h>
#include <stdint.h>
#include "adc.h"

void ADC_Init(void)
{
    ADCSRA = (1<<ADPS2) | (1<<ADPS1) | (1<<ADPS0); // Max res
    ADCSRB = (((PF7&0x20)==0?0:1)<<MUX5); // Canal selection
    ADMUX  = PF7&0x1f;
    ADMUX  |= (0<<REFS1) | (1<<REFS0);  // AVCC measurements
    ADCSRA |= (1<<ADEN);    // Converter activated
}

uint16_t ADC_Read(void)
{
    ADCSRA |= (1 << ADSC);          // Start the conversation
    while (ADCSRA & (1 << ADSC));   // Waits
    return ADC;                     // Returns the last 10 bits
}
