## How to use ?

Uniquement trois paquetages à installer :
`apt install gcc-avr avr-libc dfu-programmer`

## IMPORTANT

Vous pouvez ajouter un alias afin de simplifier la compilation + téléversement du programme.

Avant de lancer la commande, il faut penser à réinitialiser la carte en maintenant le bouton HWB (SW2 sur la carte) tout
en appuyant sur RESET (SW1).

```
alias run='make clean && make && sudo make upload'
```

note: c'est important de run le make upload en super-user afin d'avoir accès à la sortie USB.

## Compilation

### Par Makefile :

___
> Compilation et génération du fichier hex :

`make` Compile tous les fichiers `.c` et génère le fichier `pad.hex`.
___
> Nettoyage des fichiers générés :

`make clean` Supprime les fichiers `.o`, `.hex` et le binaire généré.
___
> Téléversement sur le microcontrôleur :

`make upload` Efface, flashe et réinitialise le microcontrôleur avec `dfu-programmer` et le fichier `pad.hex`.
___
> Récupération de la taille du fichier binaire :

`make size` Affiche la taille du binaire généré (`pad`).
___

### Par ligne de commande :

___
> Compilation du code :

```bash
avr-gcc -mmcu=atmega328p -DF_CPU=16000000UL -c -Wall -I. -Os timer.c -o timer.o
avr-gcc -mmcu=atmega328p -g -lm -Wl,--gc-sections -o timer.elf timer.o
```

___
> Téléversement sur le microcontrôleur :

```bash
avr-objcopy -j .text -j .data -O ihex timer.elf timer.hex
stty -F /dev/ttyACM0 hupcl
avrdude -F -v -p atmega328p -c stk500v1 -b 115200 -P /dev/ttyACM0 -U flash:w:timer.hex
```