#ifndef ACTIONS_H
#define ACTIONS_H

#include <stdint.h>
#include <stdbool.h>
#include "SSD1306.h"

typedef enum {
    CMD_PLAY_PAUSE,
    CMD_NEXT_TRACK,
    CMD_PREV_TRACK,
    CMD_VOLUME_UP,
    CMD_VOLUME_DOWN,
    CMD_MUTE,
    CMD_NONE
} MediaCommand_t;

typedef enum {
    CMD_COPY,
    CMD_PASTE,
    CMD_SELECT_ALL,
    CMD_SEARCH
} GeneralCommand_t;

void send_media_command(MediaCommand_t cmd);
void send_general_command(GeneralCommand_t cmd);

#endif
