#ifndef BUTTON_H
#define BUTTON_H

#include <avr/io.h>

// === Définition des ports et broches ===
#define BTN_MID_PORT        PORTE
#define BTN_MID_DDR         DDRE
#define BTN_MID_PIN_REG     PINE
#define BTN_MID_PIN         6

#define BTN_LRT_PORT        PORTB
#define BTN_LRT_DDR         DDRB
#define BTN_LRT_PIN_REG     PINB
#define BTN_LEFT_PIN        5
#define BTN_RIGHT_PIN       6
#define BTN_TOP_PIN         4

#define BTN_BOTTOM_PORT     PORTC
#define BTN_BOTTOM_DDR      DDRC
#define BTN_BOTTOM_PIN_REG  PINC
#define BTN_BOTTOM_PIN      6

// === Enum des boutons ===
typedef enum {
    BTN_LEFT,
    BTN_RIGHT,
    BTN_TOP,
    BTN_BOTTOM,
    BTN_MID
} button_t;

// === Fonctions ===
void button_init(void);
uint8_t button_is_pressed(button_t btn);

#endif