#ifndef JOYSTICK_H
#define JOYSTICK_H

#include <avr/io.h>

// === Définition des ports et broches ===
#define JOYSTICK_PORT PORTF
#define JOYSTICK_DDR  DDRF

#define JOYSTICK_PIN_REG    PINF

#define JOYSTICK_X 4
#define JOYSTICK_Y 5
#define JOYSTICK_BTN 6

#define JOY_CENTER_MIN 400
#define JOY_CENTER_MAX 600
#define JOY_UP_THRESHOLD 700
#define JOY_DOWN_THRESHOLD 300
#define JOY_RIGHT_THRESHOLD 300
#define JOY_LEFT_THRESHOLD 700

// === Fonctions ===
void joystick_init(void);
uint16_t joystick_read_x(void);
uint16_t joystick_read_y(void);
uint8_t joystick_is_pressed(void);

#endif