#ifndef LED_H
#define LED_H

#include <avr/io.h>

// === Définition des ports et broches ===
#define LED_PORT    PORTD
#define LED_DDR     DDRD

#define LED_1_PIN     7
#define LED_2_PIN     6
#define LED_3_PIN     4
#define LED_4_PIN     5

// === Constantes générales ===
#define LED_COUNT      4

// === Fonctions ===
void led_init(void);
void led_on(uint8_t led_num);
void led_off(uint8_t led_num);
void all_led_on(void);
void all_led_off(void);
void led_toggle(uint8_t led_num);

#endif
