#include "actions.h"
#include <avr/io.h>

#include "../Keyboard.h"

// Codes standards USB HID Consumer
#define MEDIA_PLAY_PAUSE 0xCD
#define MEDIA_NEXT_TRACK 0xB5
#define MEDIA_PREV_TRACK 0xB6
#define MEDIA_VOLUME_UP  0xE9
#define MEDIA_VOLUME_DOWN 0xEA
#define MEDIA_MUTE 0xE2

// Fonction pour transmettre un caractère via l'UART1 (ATmega32U4)
void USART_Transmit(unsigned char data) {
    while (!(UCSR1A & (1 << UDRE1)));
    UDR1 = data;
}


void send_media_command(MediaCommand_t cmd) {
    GLCD_Clear();
    GLCD_GotoXY(0, 20);

    uint16_t usbHIDCode = 0;

    switch (cmd) {
        case CMD_PLAY_PAUSE:
            GLCD_PrintString("Play/Pause");
            usbHIDCode = MEDIA_PLAY_PAUSE;
            break;
        case CMD_NEXT_TRACK:
            GLCD_PrintString("Next Track");
            usbHIDCode = MEDIA_NEXT_TRACK;
            break;
        case CMD_PREV_TRACK:
            GLCD_PrintString("Prev Track");
            usbHIDCode = MEDIA_PREV_TRACK;
            break;
        case CMD_VOLUME_UP:
            GLCD_PrintString("Volume Up");
            usbHIDCode = MEDIA_VOLUME_UP;
            break;
        case CMD_VOLUME_DOWN:
            GLCD_PrintString("Volume Down");
            usbHIDCode = MEDIA_VOLUME_DOWN;
            break;
        case CMD_MUTE:
            GLCD_PrintString("Mute");
            usbHIDCode = MEDIA_MUTE;
            break;
        default:
            GLCD_PrintString("No command");
            break;
    }

    // Mise à jour du rapport USB pour LUFA
    if (usbHIDCode != 0) {
        // Écriture dans la structure globale
        MediaReportData.CommandCode = usbHIDCode;
    }

    GLCD_Render();
}

void send_general_command(GeneralCommand_t cmd) {
    GLCD_Clear();
    GLCD_GotoXY(0, 20);

    uint8_t modifier = 0;
    uint8_t key = 0;

    switch (cmd) {
        case CMD_COPY:
            GLCD_PrintString("Copy");
            modifier = HID_KEYBOARD_MODIFIER_LEFTCTRL;
            key = HID_KEYBOARD_SC_C;
            break;
        case CMD_PASTE:
            GLCD_PrintString("Paste");
            modifier = HID_KEYBOARD_MODIFIER_LEFTCTRL;
            key = HID_KEYBOARD_SC_V;
            break;
        case CMD_SELECT_ALL:
            GLCD_PrintString("Select All");
            modifier = HID_KEYBOARD_MODIFIER_LEFTCTRL;
            key = HID_KEYBOARD_SC_Q; // (A sur clavier AZERTY)
            break;
        case CMD_SEARCH:
            GLCD_PrintString("Search");
            modifier = HID_KEYBOARD_MODIFIER_LEFTCTRL;
            key = HID_KEYBOARD_SC_F;
            break;
        default:
            GLCD_PrintString("No command");
            break;
    }

    // Mise à jour de la structure globale pour Keyboard.c
    if (key != 0) {
        ShortcutReportData.Modifier = modifier;
        ShortcutReportData.KeyCode = key;
    }

    GLCD_Render();
}
