#include "button.h"

void button_init(void) {
    // LEFT, RIGHT, TOP sur PORTB
    BTN_LRT_DDR &= ~((1 << BTN_LEFT_PIN) | (1 << BTN_RIGHT_PIN) | (1 << BTN_TOP_PIN));
    BTN_LRT_PORT |= (1 << BTN_LEFT_PIN) | (1 << BTN_RIGHT_PIN) | (1 << BTN_TOP_PIN);

    // BOTTOM sur PORTC
    BTN_BOTTOM_DDR &= ~(1 << BTN_BOTTOM_PIN);
    BTN_BOTTOM_PORT |= (1 << BTN_BOTTOM_PIN);

    // MID sur PORTE
    BTN_MID_DDR &= ~(1 << BTN_MID_PIN);
    BTN_MID_PORT |= (1 << BTN_MID_PIN);
}

uint8_t button_is_pressed(button_t btn) {
    switch (btn) {
        case BTN_LEFT:
            return !(BTN_LRT_PIN_REG & (1 << BTN_LEFT_PIN));
        case BTN_RIGHT:
            return !(BTN_LRT_PIN_REG & (1 << BTN_RIGHT_PIN));
        case BTN_TOP:
            return !(BTN_LRT_PIN_REG & (1 << BTN_TOP_PIN));
        case BTN_BOTTOM:
            return !(BTN_BOTTOM_PIN_REG & (1 << BTN_BOTTOM_PIN));
        case BTN_MID:
            return !(BTN_MID_PIN_REG & (1 << BTN_MID_PIN));
        default:
            return 0;
    }
}