#include <util/delay.h>
#include "buzzer.h"

void buzzer_init(void) {
    BUZZER_DDR |= (1 << BUZZER_PIN); // Configurer la broche du buzzer en sortie
    buzzer_off(); // Assurer que le buzzer est éteint au démarrage
}

void buzzer_on(void) {
    BUZZER_PORT |= (1 << BUZZER_PIN); // Activer le buzzer
}

void buzzer_off(void) {
    BUZZER_PORT &= ~(1 << BUZZER_PIN); // Désactiver le buzzer
}

void buzzer_toggle(void) {
    BUZZER_PORT ^= (1 << BUZZER_PIN); // Inverser l'état du buzzer
}

void buzzer_beep(uint16_t duration_ms) {
    buzzer_on();
    for(uint16_t i = 0; i < duration_ms; i++) {
        _delay_ms(1);
    }
    buzzer_off();
}