#include "joystick.h"

void joystick_init(void) {
    // === Configurer les broches du joystick en entrée ===
    JOYSTICK_DDR &= ~((1 << JOYSTICK_X) | (1 << JOYSTICK_Y) | (1 << JOYSTICK_BTN));
    // Activer la résistance de pull-up pour le bouton du joystick
    JOYSTICK_PORT |= (1 << JOYSTICK_BTN);

    // === Initialisation de l'ADC ===
    ADMUX = (1 << REFS0);               // Référence de tension = AVcc
    ADCSRA = (1 << ADEN)                // Activer ADC
           | (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0); // Prescaler = 128
}

static uint16_t adc_read(uint8_t channel) {
    ADMUX = (ADMUX & 0xF0) | (channel & 0x0F); // Sélection du canal (PF4 = ADC4, PF5 = ADC5)
    ADCSRA |= (1 << ADSC);                     // Lancer la conversion
    while (ADCSRA & (1 << ADSC));              // Attendre la fin
    return ADC;                                // Retourner la valeur sur 10 bits (0–1023)
}

uint16_t joystick_read_x(void) {
    return adc_read(JOYSTICK_X);  // PF4 → ADC4
}

uint16_t joystick_read_y(void) {
    return adc_read(JOYSTICK_Y);  // PF5 → ADC5
}

uint8_t joystick_is_pressed(void) {
    return !(JOYSTICK_PIN_REG & (1 << JOYSTICK_BTN)); // Bouton actif à l'état bas
}
