#include "led.h"

static uint8_t led_pin(uint8_t led_num) {
    switch (led_num) {
        case 1: return LED_1_PIN;
        case 2: return LED_2_PIN;
        case 3: return LED_3_PIN;
        case 4: return LED_4_PIN;
        default: return LED_1_PIN; // Par défaut LED1
    }
}

void led_init(void) {
    LED_DDR |= (1 << LED_1_PIN) | (1 << LED_2_PIN) | (1 << LED_3_PIN) | (1 << LED_4_PIN);
}

void led_on(uint8_t led_num) {
    LED_PORT |= (1 << led_pin(led_num));
}

void led_off(uint8_t led_num) {
    LED_PORT &= ~(1 << led_pin(led_num));
}

void led_toggle(uint8_t led_num) {
    LED_PORT ^= (1 << led_pin(led_num));
}

void all_led_on(void){
    for(uint8_t i = 1; i <= LED_COUNT; i++){
        led_on(i);
    }
}

void all_led_off(void){
    for(uint8_t i = 1; i <= LED_COUNT; i++){
        led_off(i);
    }
}