//
// Fichier de déclaration des constantes de configuration LUFA
// Aussi constantes utilisées pour la programmation dans tout le code
// Created by léo on 25/10/2025.
//



#ifndef BINIOUKEY_CONSTANTS_H

#define BINIOUKEY_CONSTANTS_H

// IDS
#define VENDOR_ID  0x1953
#define PRODUCT_ID 0x0001
#define MANUFACTURER_DESCRIPTION L"BigoudenCrypt"
#define PRODUCT_DESCRIPTION      L"BiniouKey"

// Endpoints
#define VENDOR_IN_EPADDR  (ENDPOINT_DIR_IN | 1)  // Endpoint USB in
#define VENDOR_OUT_EPADDR (ENDPOINT_DIR_OUT | 2) // Endpoint USB out

// Paramètres endpoint (polling en ms)
#define POLLING_MS_IN  0x05
#define POLLING_MS_OUT 0x05

// Taille des données transitant par les endpoints (byte)
#define VENDOR_IN_EPSIZE  16 // Changer avec le nombre d'octet à transférer [8, 64]
#define VENDOR_OUT_EPSIZE 8 // Changer avec le nombre d'octet à transférer [8, 64]

// Endpoint de contôle : valeurs possibles pour actions
#define CONTROL_ENDPOINT_CMD_GENERATE 0x03

// Autres trucs
#define MAX_POWER_CONSUMPTION 100 // Consommation (en mA)

// Les éléments de la carte
#define THERMISTOR          PF1
#define FLOATING_PIN        PF0
#define LED                 PD4

#define UP_BUTTON           PB4
#define LEFT_BUTTON         PB5
#define CENTER_BUTTON       PE6
#define RIGHT_BUTTON        PB6
#define DOWN_BUTTON         PC6

// Programmation
#define MDP_SIZE    VENDOR_IN_EPADDR
#define TRNG_ORIGIN FLOATING_PIN

#define KEY_LENGTH          16
#define MAX_KEYS            8
#define NO_KEY_SELECTED     0xFF 

#endif //BINIOUKEY_CONSTANTS_H