//
// Created by léo on 25/10/2025.
// C'est ici que se passe l'action!!!
//

#include "../Constants.h"
#include "Display.h"
#include <avr/io.h>


// Fonctions de setup

void setup_clock(void) {
    CLKSEL0 = 0b00010101;
    CLKSEL1 = 0b00001111;
    CLKPR = 0b10000000;
    CLKPR = 0;
}

void ad_init(const unsigned char channel){
    // --- 1) Référence AVCC ---
    ADMUX = (1 << REFS0);   // REFS0=1 → AVCC ; REFS1=0

    // --- 2) Clear des bits MUX ---
    ADMUX  &= 0b11100000;   // efface MUX4..0
    ADCSRB &= ~(1 << MUX5); // MUX5 = 0 pour ce mode (cf datasheet)

    // Gain 1x:
    // ADMUX |= (1 << MUX4);

    // Gain 10x:
    // ADMUX |= (1 << MUX3) | (1 << MUX0);

    // Gain 40x:
    // ADMUX |= (1 << MUX3) | (1 << MUX1);

    // Gain 200x:
    ADMUX |= (1 << MUX3) | (1 << MUX1) | (1 << MUX0);

    // --- 4) Prescaler : ÷128 (F_CPU=16MHz -> F_ADC ≈125 kHz) ---
    ADCSRA = (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0);

    // --- 5) Activation de l’ADC ---
    ADCSRA |= (1 << ADEN);
}

/**
 * Setup de tout ce qu'il faut pour AVR
 */
void setup_all(void) {
    setup_clock();
    ad_init(TRNG_ORIGIN);

    DDRD |= (1 << LED);
}


// Actions BiniouKey

/**
 * Récupérer 2 octets aléatoires
 *
 * @return long unsigned sur 2 bytes
 */
unsigned long ad_capture(void){
    ADCSRA |= (1<<ADSC);         // Début de conversion
    while(ADCSRA & (1<<ADSC));   // Attente de la fin de conversion
    return ADCL | ADCH << 8;     // Deux octets retournés
}
