//
// Created by antame on 08/01/2026.
// Quelques méthodes utilitaires pour manipuler les boutons.
//

#include "Button.h"
#include <avr/io.h>

/**
 * Initialiser les boutons.
 */
void setup_buttons() {
    DDRB &= ~(1 << UP_BUTTON); // Configure PF0 en entrée
    PORTB |= (1 << UP_BUTTON); // Active la résistance de pull-up

    DDRC &= ~(1 << DOWN_BUTTON); // Configure PF0 en entrée
    PORTC |= (1 << DOWN_BUTTON); // Active la résistance de pull-up

    DDRB &= ~(1 << LEFT_BUTTON); // Configure PF0 en entrée
    PORTB |= (1 << LEFT_BUTTON); // Active la résistance de pull-up

    DDRB &= ~(1 << RIGHT_BUTTON); // Configure PF0 en entrée
    PORTB |= (1 << RIGHT_BUTTON); // Active la résistance de pull-up

    DDRE &= ~(1 << CENTER_BUTTON); // Configure PF0 en entrée
    PORTE |= (1 << CENTER_BUTTON); // Active la résistance de pull-up
}


bool is_up_button_pressed(void) {
    return !(PINB & (1 << UP_BUTTON));
}

bool is_down_button_pressed(void) {
    return !(PINC & (1 << DOWN_BUTTON));
}

bool is_left_button_pressed(void) {
    return !(PINB & (1 << LEFT_BUTTON));
}

bool is_right_button_pressed(void) {
    return !(PINB & (1 << RIGHT_BUTTON));
}

bool is_center_button_pressed(void) {
    return !(PINE & (1 << CENTER_BUTTON));
}