//
// Created by antame on 08/01/2026.
// Quelques méthodes utilitaires pour manipuler l'écran.
//

#include "Display.h"

void setup_screen() {
    ssd1306_init();
    ssd1306_setFixedFont(ssd1306xled_font6x8);
    clear_screen();
}

void clear_screen() {
    ssd1306_clearScreen();
}

void display_string(const char* str, const int line) {
    if (0 <= line && line <= 8) {
        clear_line(line);
        ssd1306_printFixed(0, line * 8, str, STYLE_NORMAL);
    }
}

void clear_line(const int line) {
    ssd1306_printFixed(0, line * 8, "                     ", STYLE_NORMAL);
}


void clear_body() {
    for (size_t i = 2; i < 8; i++)
    {
        clear_line(i);   
    }
}


void display_title() {
    display_string("      BINIOUKEY      ", 0);
    display_string("---------------------", 1);
} 

void display_buttons_usage() {
    clear_body();
    display_string("UP   : Generate a key", 2);
    display_string("CENT.: Send key to   ", 3);
    display_string("       SarrasinDef.  ", 4);
    display_string("RIGHT: Go to next key", 5);
    display_string("LEFT : Reset the BK  ", 6);
    display_string("DOWN : Delete key    ", 7);
}
 



