//
// Created by antame on 08/01/2026.
// Quelques méthodes utilitaires pour manipuler l'écran.
//

#ifndef BINIOUKEY_DISPLAY_H
#define BINIOUKEY_DISPLAY_H



#include "ssd1306.h"

/**
 * Initialiser l'écran.
 */
void setup_screen();

/**
 * Nettoyer l'entièrement de l'écran.
 */
void clear_screen();

/**
 * Afficher du texte sur une ligne spécifique de l'écran.
 * @param str La chaîne à afficher.
 * @param line Le numéro de la ligne (0..7)
 */
void display_string(const char* str, const int line);

/**
 * Effacer le contenu d'une ligne.
 * @param line La ligne à effacer.
 */
void clear_line(const int line);

/**
 * Effacer tout l'écran sauf l'en-tête.
 */
void clear_body();

/**
 * Afficher un titre sur les 2 premières lignes (lignes jaunes).
 * 
 */
void display_title();

/**
 * Afficher l'utilisation des boutons.
 */
void display_buttons_usage();

#endif //BINIOUKEY_DISPLAY_H


