//
// Created by léo on 11/01/2026.
//

#include "Generation.h"
#include "StorageHandler.h"
#include "Display.h"
#include "Action.h"

/**
 * Récupérer un caractère aléatoire
 *
 * @return char
 */
char get_random_char(void) {
    int c = 0;
    for (int i = 0; i < 8; i++) {
        // On récupère 2 octets random
        const unsigned long capture = ad_capture();
        // On prend le ième bit
        c |= (capture & 0x1) << i;
    }
    // On transforme ça on caractère
    return (char)(33 + (c % 94));
}

void generate_key(char *buffer) {
    for (size_t i = 0; i < KEY_LENGTH; i++)
    {
        buffer[i] = get_random_char();
    }
    buffer[KEY_LENGTH] = '\0';
}

int generate_and_save(char *buffer) {
    generate_key(buffer);

    uint8_t new_index = get_next_free_index();
    uint8_t status = store_key(buffer, &new_index);

    return status == 0 ? new_index : 0xff;
}