//
// Created by léo on 13/11/2025.
//

#include "Usb.h"

#include "../Constants.h"
#include <LUFA/Drivers/USB/USB.h>

char *handle_out(void) {
    // On prend l'endpoint out, et on configure la réception des données
    Endpoint_SelectEndpoint(VENDOR_OUT_EPADDR);
    static char buffer[VENDOR_OUT_EPSIZE + 1];

    // On check si on a des données qui arrivent
    if (Endpoint_IsOUTReceived()) {

        // On check si on a des
        if (Endpoint_IsReadWriteAllowed()) {
            // Lecture
            uint8_t bytesRead = 0;
            // Temps qu'on a des données ou qu'on a pas rempli le tableau de données
            while (Endpoint_BytesInEndpoint() && bytesRead < sizeof(buffer) - 1) {
                buffer[bytesRead++] = Endpoint_Read_8();
            }
            buffer[bytesRead] = '\0';

            // Clear et retourne les données
            Endpoint_ClearOUT();
            return buffer;
        }
        // On a reçu mais sans données : on ack et ça dégage
        Endpoint_ClearOUT();
    }
    return NULL;
}

void handle_in(char* data) {
    // TODO: tester qu'on envoie au max x bytes
    // int data_size = sizeof(data);

    // Sélection endpoint
    Endpoint_SelectEndpoint(VENDOR_IN_EPADDR);

    // Est-ce qu'on peut bien envoyer des trucs
    if (Endpoint_IsINReady()) {
        // Write 8 bytes
        for (uint8_t i = 0; i < 16; i++) {
            Endpoint_Write_8(data[i]);
        }

        // Fin de l'envoi
        Endpoint_ClearIN();
    }
}