
# BiniouKey

<img src="https://wiki-se.plil.fr/mediawiki/images/thumb/f/f2/BiniouKey_GMbH.png/600px-BiniouKey_GMbH.png" height="64" alt="BiniouKey Logo">


La BiniouKey est un système embarqué  qui offre la possibilité de se construire un portefeuille de mots de passe générés aléatoirement à partir du bruit électronique ambiant. Elle est dotée d'une capacité exceptionnelle et peut contenir jusqu'à **8** clés !

La BiniouKey fonctionne encore mieux avec le mini-logiciel de chiffrement de fichiers [SarrasinDefender](https://gitlab.dpt-info.univ-littoral.fr/binioukey/sarrasin-defender).

## Auteurs

- **AMELOOT Antoine :** antoine.ameloot@etu.univ-littoral.fr
- **FLORES Pascal :** pascal.flores@etu.univ-littoral.fr
- **VARLAMOFF Léopold :** leopold.varlamoff@etu.univ-littoral.fr

## Démo

Lien vers la vidéo présentant les fonctionnalités **physiques** de la BiniouKey : https://wiki-se.plil.fr/mediawiki/images/0/0f/D%C3%A9monstration_de_la_Binioukey.mp4

## Utilisation

Lors du démarrage de la BiniouKey, un menu affiche les commandes suivantes : 

- **Bouton gauche :** Réinitialiser la mémoire et supprimer toutes les clés sauvegardées.
- **Bouton haut :** Créer et sauvegarder une nouvelle clé.
- **Bouton droit :** Parcourir et sélectionner les clés sauvegardées.
- **Bouton central :** Envoyer à SarrasinDefender la clé sélectionnée.
- **Bouton bas :** Supprimer la clé sélectionnée. 

## Installation

### Dépendances

- avr-gcc
- dfu-programmer
- make

## Architecture

```
I2L/Binioukey/
lib/
├─ lufa/
├─ ssd1306_lexus/
```

Le dossier `I2L/Binioukey` contient les sources du projet.

Le dossier `lib` contient deux librairies :
- [lufa](https://github.com/abcminiuser/lufa), utilisée pour faire fonctionner le système en USB,
- [ssd1306_lexus](https://github.com/lexus2k/ssd1306), utilisée pour manipuler l'écran.

### Mise en place

Se rendre dans le dossier des sources.

```sh
cd I2L/Binioukey
```

Compiler les sources.

```sh
make clean
make
```

Transférer le programme sur la carte. **Mettre la carte en mode _bootloader_ avant de lancer la commande.**

```sh
sudo make dfu
```

## Troubleshooting

**L'écran de ma Binioukey s'est figé.**

Il s'agit d'un problème récurrent qui conduit au crash de la carte. Débrancher puis rebrancher la Binioukey.

**La Binioukey ne répond pas aux commandes.**

Il s'agit d'un problème récurrent qui conduit au crash de la carte. Débrancher puis rebrancher la Binioukey.

**La clé générée ne me semble pas très sécurisée.**

Si la combinaison proposée par la BiniouKey ne vous convient pas, vous pouvez en générer une nouvelle en frottant votre doigt sur la zone inférieure droite pendant la génération.