#!/usr/bin/env python3
"""
Liste les périphériques USB via pyusb et affiche VID/PID + info d'interfaces/endpoints.
Usage: python3 list_usb.py
"""
import usb.core
import usb.util

def main():
    devs = usb.core.find(find_all=True)
    found = False
    for d in devs:
        found = True
        try:
            vid = d.idVendor
            pid = d.idProduct
        except Exception:
            vid = None; pid = None
        print(f"Device: bus={d.bus} address={d.address} idVendor=0x{vid:04x} idProduct=0x{pid:04x}")
        try:
            for cfg in d:
                print(f"  Config {cfg.bConfigurationValue}")
                for intf in cfg:
                    print(f"    Interface {intf.bInterfaceNumber} alt={intf.bAlternateSetting} class=0x{intf.bInterfaceClass:02x}")
                    for ep in intf:
                        print(f"      Endpoint addr=0x{ep.bEndpointAddress:02x} attr=0x{ep.bmAttributes:02x} maxpkt={ep.wMaxPacketSize}")
        except usb.core.USBError as e:
            print(f"  (unable to read config: {e})")
        except Exception as e:
            print(f"  (error: {e})")
        print()
    if not found:
        print("No USB devices found via pyusb. Ensure libusb is installed and you have permissions.")

if __name__ == '__main__':
    main()
