#ifndef SERVO_H
#define SERVO_H

#include <avr/io.h>
#include <stdint.h>

// Limites du servo (Valeurs brutes Timer0 8-bit / 256 prescaler)
// 5 = ~80us, 19 = ~300us (Fonctionnement observé sur V0)
#define ANGLE_MIN 5
#define ANGLE_MAX 19

// Variables globales du servo
extern uint32_t angle;
extern int servoDirection;

// Fonctions
void setupServo(void);
void setServoAngle(uint32_t newAngle);
uint32_t getAngle(void);
int getServoDirection(void);
void setServoDirection(int newDirection);
void rotateServo(void);

#endif
