#include <avr/io.h>
#include <util/delay.h>

#define US_DDR   DDRF
#define US_PORT  PORTF
#define US_PIN   PINF
#define US_TRIGGER PF4
#define US_ECHO    PF5

void sonar_init(void){
    US_DDR |= (1 << US_TRIGGER);
    US_DDR &= ~(1 << US_ECHO);
    US_PORT &= ~(1 << US_TRIGGER);
}

uint16_t sonar_mesure(void){
    uint32_t count = 0;

    // Impulsion TRIG (10us)
    US_PORT |= (1 << US_TRIGGER);
    _delay_us(12);
    US_PORT &= ~(1 << US_TRIGGER);

    // Attendre front montant (max ~10ms)
    uint16_t timeout = 10000;
    while (!(US_PIN & (1 << US_ECHO))) {
        if (--timeout == 0) return 0;
    }

    // Mesurer durée front haut
    while (US_PIN & (1 << US_ECHO)) {
        _delay_us(1);
        count++;
        if (count > 25000) break; // ~25ms max
    }

    // Conversion en cm (count us / 58)
    uint16_t dist = (uint16_t)(count / 58);
    
    if (dist > 400) dist = 0;
    
    return dist;
}
