# Sarrasin Defender

<img src="https://wiki-se.plil.fr/mediawiki/images/5/58/Logo_de_SarrasinDefender.png" height="64" alt="BiniouKey Logo">


> Sarrasin Defender fonctionne encore mieux avec la [BiniouKey](https://gitlab.dpt-info.univ-littoral.fr/binioukey/binioukey) !  

Sarrasin Defender est un logiciel qui permet de sécuriser des fichiers via `gpg`. Pour chiffrer vos données, il vous suffit de brancher votre BiniouKey et le tour est joué !

## Installation

### Dépendances

- `pkg-config`
- `cmake`
- `make`
- `libusb`
- `gpg`

### Compilation

1. Créer le Makefile.

```sh
cmake .
```

2. Compiler les sources.

```sh
make
```

3. Lancer le programme.

```sh
./main.o
```

## Utilisation

SarrasinDefender s'utilise avec la BiniouKey. Les commandes disponibles sont : 

- `help` : Affiche une aide sur les différentes commandes utilisables 

- `encrypt <file>` : Chiffrer un fichier via gpg. Le programme attend jusqu'à 30 secondes pour recevoir une clé depuis la Binioukey.

    > **Rappel :** Sur la BiniouKey, le bouton droit permet de parcourir les clés sauvegardées et le bouton central d'envoyer la clé courante.

- `decrypt <file>` : Déchiffrer un fichier `.gpg`. Le programme attend jusqu'à 30 secondes pour recevoir une clé depuis la Binioukey.

     > **Rappel :** Sur la BiniouKey, le bouton droit permet de parcourir les clés sauvegardées et le bouton central d'envoyer la clé courante.

- `generate` : Demander à la BiniouKey de générer et de sauvegarder une clé. **Aucun retour n'est donné hormis un accusé de réception.**

- `copy [--sanitize]` : Copier un mot de passe de la BiniouKey vers le presse-papier. Le programme attend jusqu'à 30 secondes pour recevoir une clé depuis la Binioukey. Avec l'option `sanitize`, la chaîne est échappée pour pouvoir être utilisée avec `gpg`.

  > **Rappel :** Sur la BiniouKey, le bouton droit permet de parcourir les clés sauvegardées et le bouton central d'envoyer la clé courante.

- `debug [on|off]` : Activer ou désactiver le mode _debug_. Le programme affiche dans la console les _logs_ de libusb ainsi que les clés en clair reçues par la BiniouKey.

- `exit` : Quitter le programme.

### Troubleshooting

**J'ai les erreurs suivantes lors du lancement du programme :**
```
libusb: error [get_usbfs_fd] libusb couldn't open USB device /dev/bus/usb/003/027, errno=13
libusb: error [get_usbfs_fd] libusb requires write access to USB device nodes
libusb_open: Permission denied
Cannot get device handler : failingUnable to find any BiniouKey! Press Enter when you want to try again
```

Lancer le programme en super-utilisateur.

```sh
sudo ./main.io
```