#include <libusb.h>
#include <stdio.h>
#include <stdlib.h>

#include "constants.h"
#include "usb.h"
#include "cli.h"

/**
 * cf. https://libusb.sourceforge.io/api-1.0/group__libusb__lib.html#ga2efb66b8f16ffb0851f3907794c06e20
 *
 * @param ctx
 * @param level
 * @param str
 */
static void cb_libusb_log(libusb_context *ctx, enum libusb_log_level level, const char *str) {
    printf("[LIBUSB LOG] %s", str);
}

int main(void) {
    libusb_context *context;
    const int init_status = libusb_init(&context);
    if (init_status != LIBUSB_SUCCESS) {
        perror("Cannot initialise libusb");
        return EXIT_FAILURE;
    }

    // Permet de gérer le log level
    // Passer à 4 (LIBUSB_LOG_LEVEL_DEBUG) si besoin de debugger un problème
    // PS: les logs ont pas l'air d'être flush donc c'est bizarre
    libusb_set_option(context, LIBUSB_OPTION_LOG_LEVEL, LIBUSB_LOG_LEVEL_ERROR);

    const BiniouKey* binioukey = waitForDevice(context);

    if (binioukey == NULL) {
        fprintf(stderr, "Fatal error in Binioukey configuration");
        return EXIT_FAILURE;
    }

    // pour pouvoir flush nous même les logs libusb
    libusb_set_log_cb(context, cb_libusb_log, LIBUSB_LOG_CB_GLOBAL);

    // claim de l'interface
    const int interface = binioukey->configuration->interface[0].altsetting[0].bInterfaceNumber;

    if (libusb_kernel_driver_active(binioukey->handle, interface)) {
        const int stt = libusb_detach_kernel_driver(binioukey->handle, interface);
        if (stt != 0) {
            perror("libusb_detach_kernel_driver");
            return EXIT_FAILURE;
        }
    }

    int status = libusb_claim_interface(binioukey->handle, interface);
    if (status != 0) {
        perror("libusb_claim_interface");
        return EXIT_FAILURE;
    }

    // quand c'est OK on peut lancer la CLI
    cli(binioukey, context);

    // unsigned char data[] = "Hello";
    // int transferred;
    // const int timeout = 1000;
    // status = libusb_interrupt_transfer(binioukey->handle, VENDOR_OUT_EPADDR, data, 8, &transferred, timeout);
    // if (status != LIBUSB_SUCCESS) {
    //     fprintf(stderr, "interrupt transfer failed: %s\n", libusb_error_name(status));
    // }
    // printf("Sent %d bytes\n", transferred);

    // status = libusb_release_interface(binioukey->handle, interface);
    // if (status != 0) {
    //     perror("libusb_release_interface");
    //     exit(-1);
    // }

    closeAndExit(context, binioukey);

    return EXIT_SUCCESS;
}