/*
 * Author: antame
 */

#ifndef SARRASIN_DEFENDER_UTILS_CLI_H
#define SARRASIN_DEFENDER_UTILS_CLI_H

#include "usb.h"

/*
 * La grosse méthode qui gère le tout
*/
int cli(const BiniouKey* binioukey, const libusb_context *context);

/*
 * Demande à la Binioukey de générer une clé. Dans l'idéal elle renvoie l'indice du tableau où la clé est stockée.
*/
int create_key(const BiniouKey* binioukey);

/*
 * Récupère la clé stockée dans la Binioukey à l'indice key_id.
*/
char* get_key(const BiniouKey* binioukey, int debug_mode, int sanitise);

/*
 * Chiffre le fichier filepath avec la clé stockée à key_id dans la Binioukey via gpg.
*/
int biniou_encrypt(const char *filepath, const char *passphrase);

/*
 * Déchiffre le fichier filepath avec la clé stockée à key_id dans la Binioukey via gpg.
*/
int biniou_decrypt(const char *filepath, const char *passphrase);

void sanitize_passphrase(char* dst, const char* src);


#endif // SARRASIN_DEFENDER_UTILS_CLI_H