#include "clipboard.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef _WIN32
const char *clipboard_cmd = "clip";
#elif __APPLE__
const char *clipboard_cmd = "pbcopy";
#elif __linux__
const char *clipboard_cmd = "xclip -selection clipboard";
#else
const char *clipboard_cmd = NULL;  // unsupported OS
#endif

int copy_to_clipboard(const char *password) {
    FILE* clipboard = popen(clipboard_cmd, "w");
    if (clipboard == NULL) {
        fprintf(stderr, "Can't open clipboard");
        return EXIT_FAILURE;
    }
    const unsigned long write_r = fwrite(password, sizeof(char), strlen(password), clipboard);
    pclose(clipboard);
    if (write_r < strlen(password)) {
        fprintf(stderr, "Error writing to clipboard (only %lu out of %lu bytes were written)", write_r, strlen(password));
        return EXIT_FAILURE;
    }
    printf("Successfully wrote password to clipboard : try pasting it!\n");
    return EXIT_SUCCESS;
}
