//
// Created by léo on 25/10/2025.
//

#ifndef SARRAZINDEFENDER_USB_H
#define SARRAZINDEFENDER_USB_H

#include <libusb.h>

/**
 * Représente une BiniouKey sous forme de périphérique USB
 */
typedef struct {
    libusb_device* device;
    struct libusb_device_descriptor *descriptor;
    struct libusb_config_descriptor *configuration;
    libusb_device_handle* handle;
} BiniouKey;

/**
 * Cherche la BiniouKey dans la liste des périphériques USB.
 * Boucle tant qu'elle n'est pas trouvée.
 *
 * @param context libusb context
 * @return une struct avec toutes les infos nécessaires
 */
BiniouKey* waitForDevice(libusb_context *context);

/**
 * Get descripteur du périphérique USB
 *
 * @param binioukey BiniouKey
 * @return OK/KO
 */
int getConfigDescriptor(BiniouKey *binioukey);

/**
 * Get handle du périphérique USB
 *
 * @param binioukey BiniouKey
 * @return OK/KO
 */
int getDeviceHandle(BiniouKey *binioukey);

/**
 * Déréférence et ferme le contexte & les éléments libusb du device
 *
 * @param context libusb context
 * @param binioukey BiniouKey
 */
void closeAndExit(libusb_context* context, const BiniouKey *binioukey);

/**
 * Debug : afficher les interfaces qu'on a trouvé
 * @param biniouKey BiniouKey
 */
void printEndpoints(const BiniouKey *biniouKey);

#endif //SARRAZINDEFENDER_USB_H