#ifndef LCD_H
#define LCD_H

#include <avr/io.h>
#include <util/delay.h>
#include <stdint.h>
#include <string.h>

// Commandes HD44780
#define LCD_CLEAR 0x01
#define LCD_HOME 0x02
#define LCD_ON 0x0C
#define LCD_OFF 0x08
#define LCD_INCR_LEFT 0x04
#define LCD_INCR_RIGHT 0x06
#define LCD_ADDRSET 0x80

// Dimensions de l'écran
#define NB_COLS 16
#define NB_ROWS 2

// Prototypes
void lcd_init(void);
void lcd_write_command(uint8_t command);
void lcd_write_data(uint8_t data);
void lcd_clear(void);
void lcd_set_cursor(uint8_t row, uint8_t col);
void lcd_write_char(char c);
void lcd_write_string(const char* str);
void lcd_animation(const char *message);

#endif