#include "leds.h"

// Initialise les broches des LEDs en sortie
void leds_init() {
    DDRB |= (1 << LED1) | (1 << LED2) | (1 << LED3); // LEDs sur PORTB
    DDRE |= (1 << LED4); // LED4 sur PORTE
}


// Allume une LED
void led_on(uint8_t port, uint8_t pin) {
    if (port == 'B') PORTB |= (1 << pin);
    else if (port == 'E') PORTE |= (1 << pin);
}

// Éteint une LED
void led_off(uint8_t port, uint8_t pin) {
    if (port == 'B') PORTB &= ~(1 << pin);
    else if (port == 'E') PORTE &= ~(1 << pin);
}

// Allumert toutes les LEDs
void leds_all_on(void) {
    PORTB |= (1 << LED1) | (1 << LED2) | (1 << LED3);
    PORTE |= (1 << LED4);
}

// Éteint toutes les LEDs
void leds_all_off(void) {
    PORTB &= ~((1 << LED1) | (1 << LED2) | (1 << LED3));
    PORTE &= ~(1 << LED4);
}