#include "pir.h"

// Initialisation des 4 capteurs PIR
void pir_init(void) {
    // --- PIR1 -> PC6 ---
    DDRC &= ~(1 << PIR1);   // entrée
    PORTC |=  (1 << PIR1);  // pull-up activé

    // --- PIR2 -> PC7 ---
    DDRC &= ~(1 << PIR2);
    PORTC |=  (1 << PIR2);

    // --- PIR3 -> PF1 ---
    DDRF &= ~(1 << PIR3);
    PORTF |=  (1 << PIR3);

    // --- PIR4 -> PF4 ---
    DDRF &= ~(1 << PIR4);
    PORTF |=  (1 << PIR4);
}

// --- Fonctions de lecture des PIRs ---
// Renvoient 1 si détection (niveau haut), 0 sinon
uint8_t pir1_is_active(void) {
    return (PINC & (1 << PIR1)) != 0;
}

uint8_t pir2_is_active(void) {
    return (PINC & (1 << PIR2)) != 0;
}

uint8_t pir3_is_active(void) {
    return (PINF & (1 << PIR3)) != 0;
}

uint8_t pir4_is_active(void) {
    return (PINF & (1 << PIR4)) != 0;
}
