import serial
import time

class SerialCom:
    def __init__(self, port="/dev/ttyACM0", baudrate=9600):
        self.ser = serial.Serial(port, baudrate, timeout=0.1)
        time.sleep(2)  # reset USB

    def send(self, message):
        self.ser.write((message + "\n").encode())

    def read(self):
        if self.ser.in_waiting:
            return self.ser.readline().decode().strip()
        return None
