class RoomController:
    def __init__(self, serial):
        self.serial = serial
        self.state = {
            1: False,
            2: False,
            3: False,
            4: False
        }

    def set_room(self, room, on):
        cmd = f"CH{room}_{'ON' if on else 'OFF'}"
        self.serial.send(cmd)
        self.state[room] = on

    def all_on(self):
        self.serial.send("ALL_ON")
        for k in self.state:
            self.state[k] = True

    def all_off(self):
        self.serial.send("ALL_OFF")
        for k in self.state:
            self.state[k] = False
