import tkinter as tk
from gui.room_widget import RoomWidget

class App(tk.Tk):
    def __init__(self, controller):
        super().__init__()
        self.title("Domotique – Control Home")
        self.geometry("500x500")

        self.controller = controller

        frame = tk.Frame(self)
        frame.pack(expand=True)

        self.rooms = []
        for i in range(1, 5):
            w = RoomWidget(frame, i, controller)
            w.grid(row=(i-1)//2, column=(i-1)%2, padx=10, pady=10)
            self.rooms.append(w)

        tk.Button(self, text="ALL ON", command=self.all_on).pack(pady=5)
        tk.Button(self, text="ALL OFF", command=self.all_off).pack(pady=5)

    def all_on(self):
        self.controller.all_on()
        for r in self.rooms:
            r.on()

    def all_off(self):
        self.controller.all_off()
        for r in self.rooms:
            r.off()
