import tkinter as tk
from gui.colors import OFF_COLOR, ON_COLOR

class RoomWidget(tk.Frame):
    def __init__(self, master, room_id, controller):
        super().__init__(master, bg=OFF_COLOR, width=200, height=200)
        self.room_id = room_id
        self.controller = controller

        self.label = tk.Label(self, text=f"CH{room_id} OFF", fg="white", bg=OFF_COLOR)
        self.label.pack(pady=10)

        tk.Button(self, text="ON", command=self.on).pack(side="left", padx=10)
        tk.Button(self, text="OFF", command=self.off).pack(side="right", padx=10)

    def on(self):
        self.controller.set_room(self.room_id, True)
        self.configure(bg=ON_COLOR)
        self.label.config(text=f"CH{self.room_id} ON", bg=ON_COLOR)

    def off(self):
        self.controller.set_room(self.room_id, False)
        self.configure(bg=OFF_COLOR)
        self.label.config(text=f"CH{self.room_id} OFF", bg=OFF_COLOR)
