#include "sound.h"

#define WINDOW_SIZE 8
#define CLAP_DELTA 50   // Ajustable

static uint16_t baseline = 0;

void sound_init(void) {
    // AVcc comme référence
    ADMUX = (1 << REFS0);

    // Sélection du canal ADC7 = PF7  (MUX=00111)
    ADMUX = (ADMUX & 0xE0) | 0x07;

    // ADC enable + prescaler 128
    ADCSRA = (1 << ADEN)
           | (1 << ADPS2) | (1 << ADPS1) | (1 << ADPS0);

    // Stabilisation du baseline
    uint32_t sum = 0;
    for(int i=0; i<30; i++){
        sum += sound_read();
        _delay_ms(5);
    }
    baseline = sum / 30;
}

uint16_t sound_read(void) {
    ADCSRA |= (1 << ADSC);
    while (ADCSRA & (1 << ADSC));
    return ADC;
}

uint8_t sound_detected(void) {
    uint32_t sum = 0;
    for(uint8_t i=0; i<WINDOW_SIZE; i++)
        sum += sound_read();

    uint16_t avg = sum / WINDOW_SIZE;

    if (avg > baseline + CLAP_DELTA) {
        baseline = (baseline*3 + avg)/4;
        return 1;
    }

    baseline = (baseline*15 + avg)/16;
    return 0;
}
