#include "ex1.h"

void lcd_pulse_enable() {
	// Fonction qui modifie le Enable pour actualiser l'écran
	LCD_CTRL_PORT |= (1 << LCD_E_PIN);
	_delay_us(1);
	LCD_CTRL_PORT &= ~(1 << LCD_E_PIN);
	_delay_us(1);
}

void lcd_send_byte(uint8_t rs, uint8_t data) {
	// RS : 0 = commande, 1 = data
	if(rs){
		LCD_RS_PORT |= (1 << LCD_RS_PIN);
	}
	else{
		LCD_RS_PORT &= ~(1 << LCD_RS_PIN);
	}

	// On indique RW en écriture (0)
	LCD_CTRL_PORT &= ~(1 << LCD_RW_PIN);

	// Envoie des 8 bits sur PORTC
	LCD_DATA_PORT = data;

	lcd_pulse_enable();
	_delay_ms(2);
}

static void lcd_command(uint8_t cmd) {
	lcd_send_byte(0, cmd);
}

static void lcd_data(uint8_t data) {
	lcd_send_byte(1, data);
}

void lcd_init(void) {
	// Configurer les ports comme sorties

	// On met les pins 0 à 7 en sortie pour recevoir de la donnée
	LCD_DATA_DDR |= (1 << LCD_D0)|(1 << LCD_D1)|(1 << LCD_D2)|(1 << LCD_D3)|(1 << LCD_D4)|(1 << LCD_D5)|(1 << LCD_D6)|(1 << LCD_D7);


	LCD_RS_DDR |= (1 << LCD_RS_PIN);	// On met RS en sortie
	LCD_CTRL_DDR |= (1 << LCD_RW_PIN) | (1 << LCD_E_PIN);	// On met RW et Enable en sortie

	_delay_ms(50); // Attente démarrage LCD

	// Séquence d'initialisation HD44780 en 8 bits
	lcd_command(0x38); // 8-bit, 2 lignes, 5x8 font
	lcd_command(DISPLAY_MODE); // On met le bon mode d'affichage
	lcd_command(ENTRY_MODE); // Entry mode (auto increment)
	lcd_command(CLEAR_DISPLAY); // Clear display
	_delay_ms(2);
}

void lcd_set_cursor(uint8_t row, uint8_t col) {
	// Définition des lignes logicielles par rapport aux adresses matérielles
	uint8_t row_offsets[] = {LCD_ROW_1, LCD_ROW_2, LCD_ROW_3, LCD_ROW_4};
	// On indique où on va écrire ou lire le caractère
	lcd_command(SET_DDRAM | (col + row_offsets[row]));
}

void lcd_print_row(const char *str, uint8_t row) {
	// On indique la ligne d'écriture pour pouvoir ajuster si besoin
	uint8_t col = 0;
	// On vérifie si la ligne est correcte
	if(row<0 || row >= LCD_ROWS){
		row = 0;
	}
	// On affiche le texte
	while (*str){
		lcd_set_cursor(row, col);
		lcd_data(*str++);
		col++;
		if(col >= LCD_COLUMNS){
			// On passe une nouvelle ligne si besoin
			col = 0;
			row++;
			if(row >= LCD_ROWS){
				// On boucle si besoin
				row = 0;
			}
		}
	}
}

void lcd_print(const char *str){
	// On facilite l'écriture d'un texte
	lcd_print_row(str, 0);
}

int main(void){
	CLKPR = 0b10000000;     // modification du diviseur d'horloge (CLKPCE=1)
	CLKPR = 0;				// 0 pour pas de diviseur

	lcd_init();
	//lcd_set_cursor(0, 0);
	lcd_print("Salu, comment ca va ? J'espere que vous allez bien");

	//lcd_set_cursor(1, 0);
	//lcd_print("Ligne 2", 1);
	//lcd_set_cursor(2, 0);
	//lcd_print("Ligne 3", 2);
	//lcd_set_cursor(3, 0);
	//lcd_print("Ligne katre", 3);
	
	
	while(1);
	return 0;
}