#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdint.h>
#include <stddef.h>
#include <util/delay.h>

// --- Définition des broches LCD ---
#define LCD_DATA_PORT PORTC
#define LCD_DATA_DDR  DDRC

#define LCD_RS_PORT PORTB
#define LCD_RS_DDR  DDRB
#define LCD_RS_PIN  PB7

#define LCD_CTRL_PORT PORTE
#define LCD_CTRL_DDR  DDRE
#define LCD_RW_PIN    PE4
#define LCD_E_PIN     PE5

// Définition sortie LCD
#define LCD_D0 PC0
#define LCD_D1 PC1
#define LCD_D2 PC2
#define LCD_D3 PC3
#define LCD_D4 PC4
#define LCD_D5 PC5
#define LCD_D6 PC6
#define LCD_D7 PC7

// Définition taille écran
#define LCD_COLUMNS 20
#define LCD_ROWS 4
#define LCD_ROW_1 0x00
#define LCD_ROW_2 0x40
#define LCD_ROW_3 0x14
#define LCD_ROW_4 0x54

// Configs
#define DISPLAY_MODE 0x0C // Display ON, Curseur OFF = 0000 001D(1) C(0)B(0)
#define ENTRY_MODE 0x06 // Entry : increment (vers la droite), curseur bouge = 0000 0001 10
#define CLEAR_DISPLAY  0x01 // Clear :  0000 0000 01
#define SET_DDRAM 0x80 // Écriture en DDRAM : 0010 0000 00

// Fonctions

void lcd_pulse_enable();

void lcd_send_byte(uint8_t rs, uint8_t data);

static void lcd_command(uint8_t cmd);

static void lcd_data(uint8_t data);

void lcd_init(void);

void lcd_set_cursor(uint8_t row, uint8_t col);

void lcd_print_row(const char *str, uint8_t row);

void lcd_print(const char *str);